﻿$pectraFolder = "c:\Program Files (x86)\Pectra Technology\" #Ruta de instalación de Pectra BPM Suite - Server Components

$dateString = (Get-Date).ToString(“s”).Replace(“:”,”-“)
$scriptPath = Split-Path -Parent -Path $MyInvocation.MyCommand.Definition
Start-Transcript -Path "$pectraFolder\Pectra BPMSuite\Logs\UpdateLog_$datestring.txt"
Write-Host "Script ejecutado en: `"$scriptPath`"."
Write-Host "Instalación de `"Pectra BPM Suite - Server Components`", en: `"$pectraFolder`"." 
try {  
    Rename-Item -Path "$pectraFolder\Pectra BPMSuite\Server\DigitalGate\WebSite\DG\Readme.txt" -NewName "Readme_$datestring.txt" -Force
    Write-Host "Copiando $scriptPath\Pectra BPMSuite\* a $pectraFolder\Pectra BPMSuite."
    Copy-Item -Path "$scriptPath\Pectra BPMSuite\*" -Destination "$pectraFolder\Pectra BPMSuite" -Recurse -Force
    $ReadmeOldPath = "$pectraFolder\Pectra BPMSuite\Server\DigitalGate\WebSite\DG\Readme_$datestring.txt"
    $ReadmeOld = Get-Content -Path $ReadmeOldPath
    Add-Content -Path "$pectraFolder\Pectra BPMSuite\Server\DigitalGate\WebSite\DG\Readme.txt" -Value $ReadmeOld -Force
    Remove-Item -Path $ReadmeOldPath -Force
    Write-Host "Archivo Readme.txt actualizado."
}
catch {
    Write-Host "Ocurrió un error:"
    Write-Host $_
}
Stop-Transcript
