﻿USE [PectraBPMSuite]

PRINT N'Modificando [dbo].[BprPackageRepository]...';


GO

IF COL_LENGTH('dbo.BprPackageRepository', 'guid') IS NULL
BEGIN
    ALTER TABLE [dbo].[BprPackageRepository] ADD [guid] UNIQUEIDENTIFIER CONSTRAINT [DF_BprPackageRepository_guid] DEFAULT (newid()) NULL;

    PRINT N'Agregando columna [guid] a [dbo].[BprPackageRepository]...';
END
GO

IF COL_LENGTH('dbo.BprPackageRepository', 'UsrId') IS NULL
BEGIN
    ALTER TABLE [dbo].[BprPackageRepository] ADD [UsrId] VARCHAR (25) NULL;

    PRINT N'Agregando columna [UsrId] a [dbo].[BprPackageRepository]...';
END
GO

IF COL_LENGTH('dbo.BprPackageRepository', 'token') IS NULL
BEGIN
    ALTER TABLE [dbo].[BprPackageRepository] ADD [token] NVARCHAR (255) NULL;

    PRINT N'Agregando columna [token] a [dbo].[BprPackageRepository]...';
END
GO

PRINT N'Creando [dbo].[BprInstAttributes].[IX_BprInstAttributes_PngId_PngInsId_AtrId]...';


GO

IF EXISTS (SELECT * FROM sys.indexes 
  WHERE name='IX_BprInstAttributes_PngId_PngInsId_AtrId' AND object_id = OBJECT_ID('dbo.BprInstAttributes'))
BEGIN
    DROP INDEX [IX_BprInstAttributes_PngId_PngInsId_AtrId] ON dbo.BprInstAttributes
END
GO

CREATE NONCLUSTERED INDEX [IX_BprInstAttributes_PngId_PngInsId_AtrId]
    ON [dbo].[BprInstAttributes]([PngId] ASC, [PngInsId] ASC, [AtrId] ASC)
    INCLUDE([AtrValue]) WITH (FILLFACTOR = 100);


GO
PRINT N'Creando [dbo].[BprInstSubProActivity].[IX_BprInstSubProActivity_PngActVersionState]...';


GO

IF EXISTS (SELECT * FROM sys.indexes 
  WHERE name='IX_BprInstSubProActivity_PngActVersionState' AND object_id = OBJECT_ID('dbo.BprInstSubProActivity'))
BEGIN
    DROP INDEX [IX_BprInstSubProActivity_PngActVersionState] ON dbo.BprInstSubProActivity
END
GO

CREATE NONCLUSTERED INDEX [IX_BprInstSubProActivity_PngActVersionState]
    ON [dbo].[BprInstSubProActivity]([PngId] ASC, [ActId] ASC, [VersionId] ASC, [ISPAState] ASC)
    INCLUDE([InsId], [ISPADate], [ISPADue]);


GO
PRINT N'Modificando [dbo].[COM_PM_PkgAdd]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[COM_PM_PkgAdd]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[COM_PM_PkgAdd]
END
GO

/*
	Design : PECTRA Fábrica
	Dev    : PECTRA Fábrica
	Date   : 23-07-2001
	Modif  :
	Params : 
		. Id de Transaccion
		. Defincion de la Instancia
	Desc   :	
	
	Inserta un package. LO identifica por un id de transaccion y guarda la definicion 
	completa de los atributos y sus valores en el campo definition.
*/
CREATE Procedure [dbo].[COM_PM_PkgAdd]
	(
		@pTrxId int,
		@pInstDefinition image
	)
As
	set nocount on


	DECLARE @UsrId VARCHAR(25)
	SET @UsrId = CAST(CAST(@pInstDefinition AS VARBINARY(MAX)) AS XML).value('(/Attributes/PectraAttributes/Attribute[AtrId="LoguedUsrId"]/AtrValue)[1]', 'VARCHAR(25)')


	INSERT INTO BprPackageRepository
		(TrxId, InstDefinition, UsrId)
	VALUES 
		(@pTrxId, @pInstDefinition, @UsrId)
	return
GO
PRINT N'Modificando [dbo].[USP_BprPackageRepository_GetByTrxId]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USP_BprPackageRepository_GetByTrxId]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USP_BprPackageRepository_GetByTrxId]
END
GO

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO


/*
----------------------------------------------------------------------------------------------------
-- Date Created: jueves, 28 de febrero de 2008

-- Created By: Prominente S.A. (http://www.prominente.com.ar/)
-- Purpose: Select records from the BprPackageRepository table through an index
----------------------------------------------------------------------------------------------------
*/


CREATE PROCEDURE [dbo].[USP_BprPackageRepository_GetByTrxId]
(

	@TrxId int   
)
AS


				SELECT
					[TrxId],
					[InstDefinition],
					[TrxDate],
					[guid],
					[token]
				FROM
					[dbo].[BprPackageRepository]
				WHERE
					[TrxId] = @TrxId
			Select @@ROWCOUNT
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creando [dbo].[BPC_PO_PackageDelOneByGuid]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[BPC_PO_PackageDelOneByGuid]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[BPC_PO_PackageDelOneByGuid]
END
GO

/*
	Design : PECTRA Fábrica
	Dev    : PECTRA Fábrica
	Date   : 24-09-2001
	Modif  : 
	Params : Id de Transaccion (GUID)
	Desc   : Elimina un Paquete. Filtra por el TrxId.
*/
CREATE PROCEDURE [dbo].[BPC_PO_PackageDelOneByGuid] ( @pTrxId UNIQUEIDENTIFIER )
AS
DELETE FROM BprPackageRepository WHERE [guid] = @pTrxId
GO
PRINT N'Creando [dbo].[USP_BprPackageRepository_DeleteByUsrId]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'USP_BprPackageRepository_DeleteByUsrId') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE USP_BprPackageRepository_DeleteByUsrId
END
GO

-- =============================================
-- Author:		hmlevrino
-- Create date: 2018-07-11
-- Description:	Elimina los packages de un usuario
-- =============================================
CREATE PROCEDURE USP_BprPackageRepository_DeleteByUsrId 
	@pUsrId varchar(25)
AS
BEGIN
	SET NOCOUNT ON;

	DELETE FROM [BprPackageRepository] WHERE UsrId = @pUsrId
END
GO

PRINT N'Creando [dbo].[USP_BprPackageRepository_UpdateToken]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[USP_BprPackageRepository_UpdateToken]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [USP_BprPackageRepository_UpdateToken]
END
GO

-- =============================================
-- Author:		hmlevrino
-- Create date: 2018-08-30
-- Description:	Actualiza la columna key de un package
-- =============================================
CREATE PROCEDURE [USP_BprPackageRepository_UpdateToken] 
	@TrxId int = null, 
	@guid uniqueidentifier = null,
	@token nvarchar(255)
AS
BEGIN
    UPDATE BprPackageRepository 
    SET token = @token
    WHERE (TrxId = @TrxId OR @TrxId IS NULL)
      AND ([guid] = @guid OR @guid IS NULL)
    OPTION (RECOMPILE)
END
GO

PRINT N'Creando [dbo].[USP_BprPackageRepository_GetByGuid]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USP_BprPackageRepository_GetByGuid]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USP_BprPackageRepository_GetByGuid]
END
GO


SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO


/*
----------------------------------------------------------------------------------------------------
-- Date Created: jueves, 28 de febrero de 2008

-- Created By: Prominente S.A. (http://www.prominente.com.ar/)
-- Purpose: Select records from the BprPackageRepository table through an index
----------------------------------------------------------------------------------------------------
*/


CREATE PROCEDURE [dbo].[USP_BprPackageRepository_GetByGuid]
(

	@TrxId uniqueidentifier    
)
AS


				SELECT
					[TrxId],
					[InstDefinition],
					[TrxDate],
					[guid],
					[token]
				FROM
					[dbo].[BprPackageRepository]
				WHERE
					[guid] = @TrxId
			Select @@ROWCOUNT
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creando [dbo].[USR_PF_GetAllByOrgUo]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USR_PF_GetAllByOrgUo]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USR_PF_GetAllByOrgUo]
END
GO

/*
	Design : PECTRA Technology
	Date   : 31/01/2018
	Modif  :
	Params : OrgId, UoId
	Desc   : Devuelve todos los perfiles filtrados por OrgId y UoID
*/

CREATE PROCEDURE [dbo].[USR_PF_GetAllByOrgUo]
(@pOrgId VARCHAR(50) = '',
 @pUoId  VARCHAR(50) = ''
)
AS
     SET NOCOUNT ON;
     SELECT [UsrOrgUoProf].[ProfId],
            [UsrProfDefinition].[ProfDescription]
     FROM [UsrOrgUoProf] WITH (NOLOCK)
          INNER JOIN [UsrProfDefinition] ON [UsrProfDefinition].[ProfId] = [UsrOrgUoProf].[ProfId]
     WHERE [OrgId] = @pOrgId
           AND [UoId] = @pUoId
           AND [UsrOrgUoProf].[Activo] = 1
           AND [UsrProfDefinition].[Activo] = 1
     ORDER BY [UsrOrgUoProf].[ProfId] ASC;
     RETURN;
GO
PRINT N'Creando [dbo].[USR_UO_GetAllByOrg]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USR_UO_GetAllByOrg]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USR_UO_GetAllByOrg]
END
GO

/*
	Design : PECTRA Technology
	Date   : 31/01/2018
	Modif  :
	Params : 
	Desc   :	
		Devuelve todas las Unidades Operacionales activas
		asignadas a Organizaciones especificas.
*/

CREATE PROCEDURE [dbo].[USR_UO_GetAllByOrg](@pOrgId VARCHAR(50) = '')
AS
     SET NOCOUNT ON;
     SELECT DISTINCT
            [UsrOrgUos].[UoId],
            [UsrUoDefinition].[UoDescription],
			[UsrOrgUos].[OrgUoDescription]
     FROM [UsrOrgUos] WITH (NOLOCK)
          INNER JOIN [UsrUoDefinition] WITH (NOLOCK) ON [UsrUoDefinition].[UoId] = [UsrOrgUos].[UoId]
     WHERE [UsrUoDefinition].[Activo] = 1
           AND [UsrOrgUos].[Activo] = 1
           AND [UsrOrgUos].[OrgId] = @pOrgId
     ORDER BY [UsrOrgUos].[UoId];
     RETURN;
GO
PRINT N'Creando [dbo].[USR_US_GetAllOrgUoProfDefaultByUser]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USR_US_GetAllOrgUoProfDefaultByUser]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USR_US_GetAllOrgUoProfDefaultByUser]
END
GO

/*
	Design : PECTRA Technology
	Date   : 05/03/2018
	Modif  :
	Params :
	Desc   :	
		Retorna todas las relaciones Organizacion-UnidadOperacional-Perfil y Default
		para un usuario especifico.
*/

CREATE PROCEDURE [dbo].[USR_US_GetAllOrgUoProfDefaultByUser](@pUsrId VARCHAR(25))
AS
     SELECT UsrOrgProfUsers.OrgId,
            UsrOrgDefinition.OrgDescription,
            UsrOrgProfUsers.UoId,
            UsrUoDefinition.UoDescription,
            UsrOrgProfUsers.ProfId,
            UsrProfDefinition.ProfDescription,
            UsrOrgProfUsers.OrgDefault
     FROM UsrOrgProfUsers WITH (NOLOCK)
          INNER JOIN UsrOrgDefinition WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgDefinition.OrgId
          INNER JOIN UsrUoDefinition WITH (NOLOCK) ON UsrOrgProfUsers.UoId = UsrUoDefinition.UoId
          INNER JOIN UsrProfDefinition WITH (NOLOCK) ON UsrOrgProfUsers.ProfId = UsrProfDefinition.ProfId
          INNER JOIN UsrOrgUos WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgUos.OrgId
                                                AND UsrOrgProfUsers.UoId = UsrOrgUos.UoId
     WHERE(UsrOrgProfUsers.UsrId = @pUsrId
           AND UsrOrgProfUsers.Activo = 1)
     ORDER BY UsrOrgProfUsers.OrgId,
              UsrOrgProfUsers.UoId,
              UsrOrgProfUsers.ProfId;
RETURN;
GO
PRINT N'Creando [dbo].[USR_UT_ValidateUsersIsAssignedToOrgUo]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USR_UT_ValidateUsersIsAssignedToOrgUo]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USR_UT_ValidateUsersIsAssignedToOrgUo]
END
GO

/*
	Design : PECTRA Technology
	Date   : 02/02/2018
	Modif  :
	Params : 
		. Id de Usuario
	Desc   :	
		Valida si un Usuario se encuentra asignado a una Unidad Operacional y Organizacion
*/
CREATE PROCEDURE [dbo].[USR_UT_ValidateUsersIsAssignedToOrgUo]
	(
		@pOrgId varchar(50) = '',
		@pUoId varchar(50) = '',
		@pUsrId	varchar(25)	= ''
	)
AS
SET NOCOUNT ON

SELECT *
FROM [UsrOrgUoUsers] WITH (NOLOCK)
WHERE	[UsrId]		=	@pUsrId AND
		[UoId]		=	@pUoId AND
		[OrgId]		=	@pOrgId 
		
RETURN


GO
PRINT N'Actualizando [dbo].[BPI_EN_InboxGet]...';
GO
/*      
 Design : PECTRA Fábrica      
 Description  :      
 Retorna todas las instancias q se correspondan con el filtro q se pasa por parametros.       
 Filtra ademas por Proceso de Negocios, Version, Subproceso y Actividad.      
*/

ALTER PROCEDURE [dbo].[BPI_EN_InboxGet]
(@pOrgId         VARCHAR(255) = '',
 @pUoId          VARCHAR(255) = '',
 @pPrfId         VARCHAR(255) = '',
 @pUsrId         VARCHAR(25)  = '',
 @pPngId         INT          = 0,
 @pVersionId     INT          = 0,
 @pSubProId      INT          = 0,
 @pActId         INT          = 0,
 @pSqlFilter     VARCHAR(MAX) = 'SELECT DISTINCT PngInsId FROM BprInstAttributes',
 @pISPAState     INT          = 1,
 @pInsId         INT          = 0,
 @pInsTop        INT          = 0,
 @pInsWhere      INT          = 0,
 @pInsOrder      INT          = 0,
 @pInsDirection  INT          = 0,
 @pStartRowIndex INT          = 1,
 @pUseHistorical BIT          = 0,
 @pLastPage      BIT          = 0,
 @pISPADate      DATETIME     = NULL
)
AS
     DECLARE @SQLWhere VARCHAR(MAX);
     DECLARE @SQLOrder VARCHAR(7500);
     DECLARE @SQLTemp VARCHAR(MAX);
     DECLARE @SQLCab VARCHAR(MAX);
     DECLARE @SQLWhereHistorico VARCHAR(MAX);
     DECLARE @SQLTempHistorico VARCHAR(MAX);
     DECLARE @SQLCabHistorico VARCHAR(MAX);
     DECLARE @pSqlFilterHistorico VARCHAR(MAX);
     DECLARE @SQL VARCHAR(MAX);
     DECLARE @sPngId VARCHAR(7500);
     DECLARE @sSubProId VARCHAR(7500);
     DECLARE @sVersionId VARCHAR(7500);
     DECLARE @sActId VARCHAR(7500);
     DECLARE @sISPAState VARCHAR(7500);
     DECLARE @sInsId VARCHAR(7500);
     DECLARE @sInsTop VARCHAR(7500);
     DECLARE @sInsWhere VARCHAR(7500);
     DECLARE @sInsOrder VARCHAR(7500);
     DECLARE @sDateWhere DATETIME;
     DECLARE @sOrderBy VARCHAR(15);
     DECLARE @sStartRowIndex VARCHAR(7500);
     DECLARE @MaxRowInQuery INT;
     IF @pInsTop <= 0
     BEGIN
         SET @pInsTop = 1;
     END;      
                     
     -- -----------------------------------------------------------------------                  
     -- Pasa los valores a varchar para ser ejecutados en el Stored Procedure                  
     -- -----------------------------------------------------------------------                          

     SELECT @sPngId = CONVERT(VARCHAR(7500), @pPngId);
     SELECT @sSubProId = CONVERT(VARCHAR(7500), @pSubProId);
     SELECT @sVersionId = CONVERT(VARCHAR(7500), @pVersionId);
     SELECT @sActId = CONVERT(VARCHAR(7500), @pActId);
     SELECT @sISPAState = CONVERT(VARCHAR(7500), @pISPAState);
     SELECT @sInsId = CONVERT(VARCHAR(7500), @pInsId);
     SELECT @sInsTop = CONVERT(VARCHAR(7500), @pInsTop);
     SELECT @sInsWhere = CONVERT(VARCHAR(7500), @pInsWhere);
     SELECT @sInsOrder = CONVERT(VARCHAR(7500), @pInsOrder);
     SELECT @sStartRowIndex = CONVERT(VARCHAR(7500), @pStartRowIndex);                  
                            
     -- -----------------------------------------------------------------------                  
     -- Verifico por que columna ordenar                           
     -- -----------------------------------------------------------------------                  
     IF @sInsWhere >= 0
     BEGIN
         SELECT @sOrderBy = 'InsId';
     END;
     ELSE
     BEGIN
         SELECT @sOrderBy = 'ISPADate';
     END;
     SET @pStartRowIndex = @pStartRowIndex + 1;                
     -- -----------------------------------------------------------------------                  
     -- Cabecera del Select, campos a seleccionar                  
     -- -----------------------------------------------------------------------                          

     SELECT @pSqlFilterHistorico = REPLACE(@pSqlFilter, 'FROM BprInstAttributes', 'FROM PectraHistorico..BprInstAttributes');
     SELECT @SQLCab = 'SELECT';
     IF @pInsTop > 0
     BEGIN
         SELECT @SQLCab = @SQLCab;
     END;
     SELECT @SQLCab = @SQLCab+'                  
                                               BprInstances.InsId AS ''InsId'',                   
                                               BprInstances.InsDate,                   
                                               BprInstances.PngInsIdMonoInst,                   
                                               BprActivity.ActDescription,                   
                                               BprActivity.ActDefinition,                   
                                               BprInstSubProActivity.ISPAState,                   
                                               BprInstSubProActivity.UsrId,                   
                                               BprInstSubProActivity.ISPADate,                   
                                               BprInstSubProActivity.ISPALock,                   
                                               BprInstSubProActivity.ISPAUsrIdLock,
											   BprInstSubProActivity.LockLog,
                                               BprInstSubProActivity.ISPADue,                  
                                               BprInstSubProActivity.DueLog,                
                                               BprInstances.PngId AS ''PngId'',                   
                                               BprInstances.VersionId AS ''VersionId'',                   
                                               BprInstances.ProId AS ''ProId'',                   
                                               BprActivity.ActId AS ''ActId'',                   
                                               BprProfiles.OrgId,                   
                                               BprProfiles.UOId,                   
                                               BprProfiles.PrfId,                   
                                               BprBusinessProcess.VersionActive,  
                                               Row_Number() OVER (partition by BprInstances.InsId order by BprInstances.InsId) as fila                            
                
                 FROM ( ';
     SELECT @SQLCabHistorico = @SQLCab;                   
                  
     -- -----------------------------------------------------------------------                  
     -- Une la tabla virtual de los Filtros (BPRInstancesFilter), con las demas                  
     -- tablas y arma el where por proceso de negocio, version, subproceso y                  
     -- Actividad.                  
     -- -----------------------------------------------------------------------                  

     SELECT @SQLTemp = ' ) AS BPRInstancesFilter                                                    
            INNER JOIN BprInstances WITH (NOLOCK)                   
                        ON BPRInstancesFilter.pnginsid = BprInstances.PngInsId                   
            INNER JOIN BprActivity WITH (NOLOCK)                  
                        ON BprInstances.PngId = BprActivity.PngId             
                        AND BprInstances.VersionId = BprActivity.VersionId                   
            INNER JOIN BprInstSubProActivity WITH (NOLOCK)                   
              ON BprInstances.InsId = BprInstSubProActivity.InsId                   
                        AND BprInstances.PngId = BprInstSubProActivity.PngId                   
                        AND BprInstances.VersionId = BprInstSubProActivity.VersionId                   
                        AND BprActivity.ActId = BprInstSubProActivity.ActId                   
            INNER JOIN BprProfiles WITH (NOLOCK)                   
                        ON BprInstances.PngId = BprProfiles.PngId                   
                        AND BprInstances.VersionId = BprProfiles.VersionId                   
            INNER JOIN BprBusinessProcess WITH (NOLOCK)                   
                        ON BprProfiles.PngId = BprBusinessProcess.PngId                   
                        AND BprProfiles.VersionId = BprBusinessProcess.VersionId                         
            INNER JOIN  UsrOrgProfUsers WITH (NOLOCK)                  
                        ON  BprProfiles.OrgId = UsrOrgProfUsers.OrgId                   
                        AND BprProfiles.UOId = UsrOrgProfUsers.UoId                   
                        AND BprProfiles.PrfId = UsrOrgProfUsers.ProfId                      
    ';
     SELECT @SQLTempHistorico = ' ) AS BPRInstancesFilter                                                 
            INNER JOIN PectraHistorico..BprInstances as BprInstances WITH (NOLOCK)                   
                        ON BPRInstancesFilter.pnginsid = BprInstances.PngInsId                   
            INNER JOIN BprActivity WITH (NOLOCK)                  
                        ON BprInstances.PngId = BprActivity.PngId                   
                        AND BprInstances.VersionId = BprActivity.VersionId                   
            INNER JOIN PectraHistorico..BprInstSubProActivity as BprInstSubProActivity WITH (NOLOCK)                   
                        ON BprInstances.InsId = BprInstSubProActivity.InsId                   
                        AND BprInstances.PngId = BprInstSubProActivity.PngId                   
                        AND BprInstances.VersionId = BprInstSubProActivity.VersionId                   
                        AND BprActivity.ActId = BprInstSubProActivity.ActId                   
            INNER JOIN BprProfiles WITH (NOLOCK)                   
                        ON BprInstances.PngId = BprProfiles.PngId                   
                        AND BprInstances.VersionId = BprProfiles.VersionId                   
            INNER JOIN BprBusinessProcess WITH (NOLOCK)                   
                        ON BprProfiles.PngId = BprBusinessProcess.PngId                   
                        AND BprProfiles.VersionId = BprBusinessProcess.VersionId                         
            INNER JOIN  UsrOrgProfUsers WITH (NOLOCK)                  
                        ON  BprProfiles.OrgId = UsrOrgProfUsers.OrgId                   
                        AND BprProfiles.UOId = UsrOrgProfUsers.UoId                   
                        AND BprProfiles.PrfId = UsrOrgProfUsers.ProfId                      
            ';                  
               
     -- -----------------------------------------------------------------------                          
     -- Filtra siempre por Org, Uo y Prf                  
     -- -----------------------------------------------------------------------                                                  

     SELECT @SQLWHere = ' WHERE ';
     IF @pInsWhere > 0                  
     --Busco por ID de Instancia                  
     BEGIN
         IF @pInsDirection = 0
         BEGIN
             SELECT @SQLWHere = @SQLWHere+' (BprInstances.InsId >= '+@sInsWhere+') AND ';
         END;
         ELSE
         BEGIN
             SELECT @SQLWHere = @SQLWHere+' (BprInstances.InsId < '+@sInsWhere+') AND ';
         END;
     END;                   
                  
     -- -----------------------------------------------------------------------                  
     -- Filtra siempre por Org, Uo y Prf                  
     -- -----------------------------------------------------------------------                                                  
     IF @pUsrId <> ''
     BEGIN
         SELECT @SQLWHere = @SQLWHere+'(UsrOrgProfUsers.UsrId = '''+@pUsrId+''') AND  ';
     END;
     IF @pOrgId <> ''
     BEGIN
         SELECT @SQLWHere = @SQLWHere+'(BprProfiles.OrgId = '''+@pOrgId+''') AND  ';
     END;
     IF @pUoId <> ''
     BEGIN
         SELECT @SQLWHere = @SQLWHere+'(BprProfiles.UOId  = '''+@pUoId+''') AND  ';
     END;
     IF @pPrfId <> ''
     BEGIN
         SELECT @SQLWHere = @SQLWHere+'(BprProfiles.PrfId = '''+@pPrfId+''') AND ';
     END;                                                          
                  
     -- -----------------------------------------------------------------------                          
     -- De acuerdoa los parametros q recibio, arma los filtros                  
     -- por PngId, VersionId, SubProId, y ActId.                  
     -- -----------------------------------------------------------------------                                      
     IF @pPngId > 0
     BEGIN
         SELECT @SQLWHere = @SQLWHere+' (BprInstances.PngId = '+@sPngId+') AND ';
     END;
     IF @pVersionId > 0
     BEGIN
         SELECT @SQLWHere = @SQLWHere+' (BprInstances.VersionId = '+@sVersionId+') AND ';
     END;
     IF @pSubProId > 0
     BEGIN
         SELECT @SQLWHere = @SQLWHere+' (BprInstances.ProId = '+@sSubProId+') AND ';
     END;
     IF @pActId > 0
     BEGIN
         SELECT @SQLWHere = @SQLWHere+' (BprActivity.ActId = '+@sActId+') AND ';
     END;
     IF @pISPAState > 0
     BEGIN
         SELECT @SQLWHere = @SQLWHere+' (BprInstSubProActivity.ISPAState = '+@sISPAState+') AND ';
     END;
     IF @pInsId > 0
        AND @pInsWhere = 0
     BEGIN
         SELECT @SQLWHere = @SQLWHere+' (BprInstances.InsId = '+@sInsId+') AND ';
     END;
	IF @pISPADate IS NOT NULL
	BEGIN
	    SELECT @SQLWHere = @SQLWHere+' (BprInstSubProActivity.ISPADate >='''+CONVERT(VARCHAR(24), @pISPADate, 126)+''') AND ';
	END;
                  
     -- QUITA EL ULTIMO 'AND'                  
     IF LEN(@SQLWHere) > 8
     BEGIN
         SELECT @SQLWHere = LEFT(@SQLWHere, LEN(@SQLWHere) - 4);
     END;
     ELSE
     BEGIN
         SELECT @SQLWHere = '';
     END;
     IF @pISPAState = 0
     BEGIN
         SELECT @SQLWhereHistorico = @SQLWHere+' AND (BprInstSubProActivity.ISPAState = 1) ';
     END;
     ELSE
     BEGIN
         SELECT @SQLWhereHistorico = @SQLWHere;
     END;                  
                  
     -- -----------------------------------------------------------------------                          
     -- Filtra por el estado y define el orden por                  
     -- PngId, VersionId, ProId, ActId e InsId                  
     -- Verificando si busca en Historico o no                  
     -- Si ISPAState = -2, solamente buscar en PectraHistorico                  
     -- -----------------------------------------------------------------------                        
     IF @pISPAState = -2
     BEGIN
         IF @pInsOrder = 0
         BEGIN
             SELECT @SQLOrder = ' ORDER BY PngId, VersionId, ProId, ActId, InsId ASC ';
         END;
         ELSE
         BEGIN
             SELECT @SQLOrder = ' ORDER BY PngId, VersionId, ProId, ActId, InsId DESC ';
         END;
     END;
     ELSE
     BEGIN
         IF @pInsOrder = 0
         BEGIN
             SELECT @SQLOrder = ' ORDER BY PngId, VersionId, ProId, ActId, '+@sOrderBy+' ASC ';
         END;
         ELSE
         BEGIN
             SELECT @SQLOrder = ' ORDER BY PngId, VersionId, ProId, ActId, '+@sOrderBy+' DESC ';
         END;
     END;                  
                  
     -- -----------------------------------------------------------------------                          
     -- Verfica si debo retornar la ultima pagina                
     -- -----------------------------------------------------------------------                     
     DECLARE @SQLMax1 NVARCHAR(MAX);
     DECLARE @LastPage INT;
     IF @pLastPage = 1
     BEGIN                  
         -- Si uso histrico....                
         IF @pUseHistorical = 1
         BEGIN                
             -- -------------------------------------------------------------------                
             -- Si ISPAState = -2, buscar solamente en PectraHistorico                
             -- Sino, hacer UNION ALL                
             -- -------------------------------------------------------------------                
             IF @pISPAState = -2
             BEGIN
                 SET @SQLMax1 = 'WITH ctePrincipal AS ('+@SQLCabHistorico+@pSqlFilterHistorico+@SQLTempHistorico+@SQLWhereHistorico+')                 
         SELECT @MaxRowInQuery = count(*) FROM ctePrincipal ';
             END;
             ELSE
             BEGIN
                 SET @SQLMax1 = 'WITH ctePrincipal AS ('+@SQLCab+@pSqlFilter+@SQLTemp+@SQLWhere+'                 
        UNION ALL '+@SQLCabHistorico+@pSqlFilterHistorico+@SQLTempHistorico+@SQLWhereHistorico+')                 
        SELECT  @MaxRowInQuery = count(*) FROM ctePrincipal';
             END;
         END;
         ELSE
         BEGIN
             SET @SQLMax1 = 'WITH ctePrincipal AS ('+@SQLCab+@pSqlFilter+@SQLTemp+@SQLWhere+')                 
        SELECT  @MaxRowInQuery = count(*) FROM ctePrincipal ';
         END;
         BEGIN
             EXEC sp_executesql
                  @SQLMax1,
                  N'@MaxRowInQuery int output',
                  @MaxRowInQuery = @MaxRowInQuery OUTPUT;
     END;                
           
   --ultima pagina                

         SELECT @LastPage = CONVERT(DECIMAL(10, 2), (CONVERT(DECIMAL(10, 2), @MaxRowInQuery) / CONVERT(DECIMAL(10, 2), @sInsTop)));           
   -- Si el valor resultante es entero (no hay resto), se vuelve una página.      
         IF(@LastPage = CONVERT(DECIMAL(10, 2), (CONVERT(DECIMAL(10, 2), @MaxRowInQuery) / CONVERT(DECIMAL(10, 2), @sInsTop))))
         BEGIN
             SELECT @LastPage = @LastPage - 1;
         END;
         SELECT @sStartRowIndex = @LastPage * @sInsTop;
     END;                
                  
     -- -----------------------------------------------------------------------                          
     -- Define el Orden de la Busqueda de las Instancias                  
     -- -----------------------------------------------------------------------                          
                  
      -- Si uso histrico....                
     IF @pUseHistorical = 1
     BEGIN                
         -- -------------------------------------------------------------------                
         -- Si ISPAState = -2, buscar solamente en PectraHistorico                
         -- Sino, hacer UNION ALL                
         -- -------------------------------------------------------------------                
         IF @pISPAState = -2
         BEGIN
             SELECT @SQL = 'WITH ctePrincipal AS ('+@SQLCabHistorico+@pSqlFilterHistorico+@SQLTempHistorico+@SQLWhereHistorico+'),
          CTE_Secundario AS (select *, Row_Number() OVER ('+@SQLOrder+') as NroFila from ctePrincipal where Fila = 1)
          SELECT * FROM CTE_Secundario WHERE ((NroFila between ('+CONVERT(NVARCHAR(10), @sStartRowIndex)+'+1)
		  AND ('+CONVERT(NVARCHAR(10), @sStartRowIndex)+' + '+CONVERT(NVARCHAR(10), @sInsTop)+') )) ';
         END;
         ELSE
         BEGIN
             SELECT @SQL = 'WITH ctePrincipal AS ('+@SQLCab+@pSqlFilter+@SQLTemp+@SQLWhere+'                    
      UNION ALL '+@SQLCabHistorico+@pSqlFilterHistorico+@SQLTempHistorico+@SQLWhereHistorico+'),
      CTE_Secundario AS (select *, Row_Number() OVER ('+@SQLOrder+') as NroFila from ctePrincipal where Fila = 1)
      SELECT * FROM CTE_Secundario WHERE ((NroFila between ('+CONVERT(NVARCHAR(10), @sStartRowIndex)+'+1)      
      AND ('+CONVERT(NVARCHAR(10), @sStartRowIndex)+' + '+CONVERT(NVARCHAR(10), @sInsTop)+') )) ';
         END;
     END;
     ELSE
     BEGIN
         SELECT @SQL = 'WITH ctePrincipal AS ('+@SQLCab+@pSqlFilter+@SQLTemp+@SQLWhere+'),
         CTE_Secundario AS (select *, Row_Number() OVER ('+@SQLOrder+') as NroFila from ctePrincipal where Fila = 1)
         SELECT * FROM CTE_Secundario WHERE ((NroFila between ('+CONVERT(NVARCHAR(10), @sStartRowIndex)+'+1)                
		 AND ('+CONVERT(NVARCHAR(10), @sStartRowIndex)+' + '+CONVERT(NVARCHAR(10), @sInsTop)+') )) ';
     END;
     EXECUTE (@SQL);
     RETURN;         

GO

/*
6.3.0.0
*/
ALTER Procedure [dbo].[BPI_EN_InstanceLockUnLock]
	(
		@pPngId int = 0,
		@pVersionId int = 0,
		@pSubProId int = 0,
		@pActId int = 0,
		@pInsId int = 0,
		@pISPALock int,
		@pISPAUsrIdLock varchar(25) = '',
		@pLockLog image = null
	)
As
	set nocount on

	UPDATE 
		BprInstSubProActivity
	SET 
		ISPALock = @pISPALock,
		ISPAUsrIdLock = @pISPAUsrIdLock,
		LockLog = @pLockLog
	WHERE 
		(InsId = @pInsId)    AND 
		(PngId = @pPngId)    AND 
		(ProId = @pSubProId) AND 
		(ActId = @pActId)    AND 
--		(ISPALock <> @pISPALock) AND
		(VersionId = @pVersionId)
	select @@Rowcount as Cantidad 


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[COM_PM_PkgAdd_Complete]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[COM_PM_PkgAdd_Complete]
END
GO

/*
6.3.0.0
*/

CREATE Procedure [dbo].[COM_PM_PkgAdd_Complete]  
 (  
  @pTrxId int,  
  @pInstDefinition image,
  @pUsrId varchar(25),
  @pGuid  uniqueidentifier
 )  
As  
 set nocount on  
 
  
 INSERT INTO BprPackageRepository  
  (TrxId, InstDefinition, UsrId, [guid])
 VALUES   
  (@pTrxId, @pInstDefinition, @pUsrId, @pGuid)  
 return   
GO


IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[RBT_PR_CommandsFailedAdd]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[RBT_PR_CommandsFailedAdd]
END
GO

/*
6.3.0.0
*/

CREATE Procedure [dbo].[RBT_PR_CommandsFailedAdd]
(
	@CmdId int,
	@pCmdDefinition as image

)
As
	
	-- inserta en la tabla de registros fallidos
	INSERT INTO RbtCommandsFailed
	    (CmdId, CmdDate, CmdDefinition, CmdFailedDate, CmdRbtServerName)
	Values
		(@CmdId, GetDate(), @pCmdDefinition, GetDate(), '')

			
return 
GO


PRINT N'Modificando [dbo].[USR_US_GetAllOrgUoProfByUserPngId]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USR_US_GetAllOrgUoProfByUserPngId]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USR_US_GetAllOrgUoProfByUserPngId]
END
GO

/*
	Design : PECTRA Technology
	Date   : 02/07/2007
	Modif  :
	Params :
	Desc   :	
		Retorna todas las relaciones Organizacion-UnidadOperacional-Perfil
		para un usuario especifico.
*/

CREATE PROCEDURE [dbo].[USR_US_GetAllOrgUoProfByUserPngId](@pUsrId VARCHAR(25), @pPngId int = NULL, @pVersionId int = NULL)
AS

IF @pPngId IS NULL AND @pVersionId IS NULL
BEGIN
     SELECT UsrOrgProfUsers.OrgId,
            UsrOrgDefinition.OrgDescription,
            UsrOrgProfUsers.UoId,
            UsrUoDefinition.UoDescription,
            UsrOrgProfUsers.ProfId,
            UsrProfDefinition.ProfDescription,
            UsrOrgUos.OrgUoDescription
     FROM UsrOrgProfUsers WITH (NOLOCK)
          INNER JOIN UsrOrgDefinition WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgDefinition.OrgId
          INNER JOIN UsrUoDefinition WITH (NOLOCK) ON UsrOrgProfUsers.UoId = UsrUoDefinition.UoId
          INNER JOIN UsrProfDefinition WITH (NOLOCK) ON UsrOrgProfUsers.ProfId = UsrProfDefinition.ProfId
          INNER JOIN UsrOrgUos WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgUos.OrgId AND UsrOrgProfUsers.UoId = UsrOrgUos.UoId
     WHERE(UsrOrgProfUsers.UsrId = @pUsrId AND UsrOrgProfUsers.Activo = 1)
     ORDER BY UsrOrgProfUsers.OrgId,
              UsrOrgProfUsers.UoId,
              UsrOrgProfUsers.ProfId;
END
ELSE IF @pPngId IS NOT NULL
BEGIN
     SELECT UsrOrgProfUsers.OrgId,
            UsrOrgDefinition.OrgDescription,
            UsrOrgProfUsers.UoId,
            UsrUoDefinition.UoDescription,
            UsrOrgProfUsers.ProfId,
            UsrProfDefinition.ProfDescription,
            UsrOrgUos.OrgUoDescription
     FROM UsrOrgProfUsers WITH (NOLOCK)
          INNER JOIN UsrOrgDefinition WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgDefinition.OrgId
          INNER JOIN UsrUoDefinition WITH (NOLOCK) ON UsrOrgProfUsers.UoId = UsrUoDefinition.UoId
          INNER JOIN UsrProfDefinition WITH (NOLOCK) ON UsrOrgProfUsers.ProfId = UsrProfDefinition.ProfId
          INNER JOIN UsrOrgUos WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgUos.OrgId AND UsrOrgProfUsers.UoId = UsrOrgUos.UoId
		INNER JOIN BprProfiles WITH (NOLOCK) ON 
		    BprProfiles.OrgId = UsrOrgProfUsers.OrgId AND
		    BprProfiles.UOId = UsrOrgProfUsers.UoId AND
		    BprProfiles.PrfId = UsrOrgProfUsers.ProfId AND 
		    BprProfiles.PngId = @pPngId AND 
		    BprProfiles.VersionId = @pVersionId
     WHERE(UsrOrgProfUsers.UsrId = @pUsrId AND UsrOrgProfUsers.Activo = 1)
     ORDER BY UsrOrgProfUsers.OrgId,
              UsrOrgProfUsers.UoId,
              UsrOrgProfUsers.ProfId;
END
RETURN;
GO


PRINT N'Modificando [dbo].[USR_US_GetAllOrgUoProfByUser]...';


GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[USR_US_GetAllOrgUoProfByUser]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[USR_US_GetAllOrgUoProfByUser]
END
GO

/*
	Design : PECTRA Technology
	Date   : 02/07/2007
	Modif  :
	Params :
	Desc   :	
		Retorna todas las relaciones Organizacion-UnidadOperacional-Perfil
		para un usuario especifico.
*/

CREATE PROCEDURE [dbo].[USR_US_GetAllOrgUoProfByUser](@pUsrId VARCHAR(25))
AS
     SELECT UsrOrgProfUsers.OrgId,
            UsrOrgDefinition.OrgDescription,
            UsrOrgProfUsers.UoId,
            UsrUoDefinition.UoDescription,
            UsrOrgProfUsers.ProfId,
            UsrProfDefinition.ProfDescription,
            UsrOrgUos.OrgUoDescription
     FROM UsrOrgProfUsers WITH (NOLOCK)
          INNER JOIN UsrOrgDefinition WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgDefinition.OrgId
          INNER JOIN UsrUoDefinition WITH (NOLOCK) ON UsrOrgProfUsers.UoId = UsrUoDefinition.UoId
          INNER JOIN UsrProfDefinition WITH (NOLOCK) ON UsrOrgProfUsers.ProfId = UsrProfDefinition.ProfId
          INNER JOIN UsrOrgUos WITH (NOLOCK) ON UsrOrgProfUsers.OrgId = UsrOrgUos.OrgId AND UsrOrgProfUsers.UoId = UsrOrgUos.UoId
     WHERE(UsrOrgProfUsers.UsrId = @pUsrId AND UsrOrgProfUsers.Activo = 1)
     ORDER BY UsrOrgProfUsers.OrgId,
              UsrOrgProfUsers.UoId,
              UsrOrgProfUsers.ProfId;
RETURN;
GO


PRINT N'Actualizando [dbo].[BPC_PO_PackageDelOne]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[BPC_PO_PackageDelOne]';


GO
PRINT N'Actualizando [dbo].[BPC_PO_PackageGetOne]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[BPC_PO_PackageGetOne]';


GO
PRINT N'Actualizando [dbo].[BPE_ClearAllInstances]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[BPE_ClearAllInstances]';


GO
PRINT N'Actualizando [dbo].[BPE_ClearPngInstances]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[BPE_ClearPngInstances]';


GO
PRINT N'Actualizando [dbo].[COM_PM_PkgGetOne]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[COM_PM_PkgGetOne]';


GO
PRINT N'Actualizando [dbo].[USP_BprPackageRepository_Delete]...';


GO
SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[USP_BprPackageRepository_Delete]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Actualizando [dbo].[USP_BprPackageRepository_Find]...';


GO
SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[USP_BprPackageRepository_Find]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Actualizando [dbo].[USP_BprPackageRepository_Get_List]...';


GO
SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[USP_BprPackageRepository_Get_List]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Actualizando [dbo].[USP_BprPackageRepository_Insert]...';


GO
SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[USP_BprPackageRepository_Insert]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Actualizando [dbo].[USP_BprPackageRepository_Update]...';


GO
SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[USP_BprPackageRepository_Update]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Actualizando [dbo].[UTI_EN_BPClearPngInstances]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[UTI_EN_BPClearPngInstances]';


GO
PRINT N'Actualizando [dbo].[UTI_EN_BprClearInstances]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[UTI_EN_BprClearInstances]';


GO


SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;


GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UsrAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[UsrAudit] (
    [UsrAuditId]  INT            IDENTITY (1, 1) NOT NULL,
    [UsrId]       VARCHAR (25)   NOT NULL,
    [AuditDate]   DATETIME       NOT NULL,
    [ServiceId]   INT            NOT NULL,
    [EntityId]    INT            NOT NULL,
    [OperationId] INT            NOT NULL,
    [Added]       NVARCHAR (MAX) NULL,
    [Modified]    NVARCHAR (MAX) NULL,
    [Deleted]     NVARCHAR (MAX) NULL,
    CONSTRAINT [PK_UsrAudit] PRIMARY KEY CLUSTERED ([UsrAuditId] ASC)
)
END
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UsrAuditEntity]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[UsrAuditEntity] (
    [UsrAuditEntityId] INT           NOT NULL,
    [Description]      VARCHAR (100) NOT NULL,
    PRIMARY KEY CLUSTERED ([UsrAuditEntityId] ASC)
)
END
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UsrAuditOperation]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[UsrAuditOperation] (
    [UsrAuditOperationId] INT           NOT NULL,
    [Description]         VARCHAR (100) NOT NULL,
    PRIMARY KEY CLUSTERED ([UsrAuditOperationId] ASC)
)
END
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UsrAuditService]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[UsrAuditService] (
    [UsrAuditServiceId] INT           NOT NULL,
    [Description]       VARCHAR (100) NOT NULL,
    [SvcId]             VARCHAR (4)   NOT NULL,
    PRIMARY KEY CLUSTERED ([UsrAuditServiceId] ASC)
)
END
GO

MERGE INTO [dbo].[UsrAuditService] AS TARGET
USING(VALUES
	(1, N'Rss Service', N'RSS'),
	(2, N'PECTRA Business Process Engine', N'BPE'),
	(3, N'PECTRA Event Dispatcher Engine', N'EVD'),
	(4, N'Scheduler', N'SCH'),
	(5, N'Notifications', N'NTF'),
	(6, N'Robot', N'RBT'),
	(7, N'PECTRA User Manager', N'USM'),
	(8, N'PECTRA Connectors Manager', N'CNM'),
	(9, N'PECTRA Analyze Engine', N'ANL'),
	(10, N'PECTRA OBPI', N'OBPI'),
	(11, N'External Process', N'EXP'),
	(12, N'DeepView', N'DPV'),
	(13, N'Digital Gate', N'DGT'),
	(14, N'Outlook Add-In', N'OUT'),
	(15, N'Document and Content Interaction', N'GDC'),
	(16, N'BAM Email Refresh', N'BAM'),
	(17, N'VerticalsImages', N'VRT')
) AS SOURCE([UsrAuditServiceId], [Description], [SvcId])
ON TARGET.[UsrAuditServiceId] = SOURCE.[UsrAuditServiceId]
    WHEN MATCHED
    THEN UPDATE SET [Description] = SOURCE.[Description], [SvcId] = SOURCE.[SvcId]
    WHEN NOT MATCHED BY TARGET
    THEN
      INSERT([UsrAuditServiceId], [Description], [SvcId])
      VALUES([UsrAuditServiceId], [Description], [SvcId])
    WHEN NOT MATCHED BY SOURCE
    THEN DELETE;
GO

MERGE INTO [dbo].[UsrAuditEntity] AS TARGET
USING(VALUES
	(1, N'Usuario'),
	(2, N'Perfil'),
	(3, N'Unidad Organizacional'),
	(4, N'Organizacion'),
	(5, N'Idioma'),
	(6, N'Conector'),
	(7, N'Paquete'),
	(8, N'Servicios'),
	(9, N'Herramientas')
) AS SOURCE([UsrAuditEntityId], [Description])
ON TARGET.[UsrAuditEntityId] = SOURCE.[UsrAuditEntityId]
    WHEN MATCHED
    THEN UPDATE SET [Description] = SOURCE.[Description]
    WHEN NOT MATCHED BY TARGET
    THEN
      INSERT([UsrAuditEntityId], [Description])
      VALUES([UsrAuditEntityId], [Description])
    WHEN NOT MATCHED BY SOURCE
    THEN DELETE;
GO

MERGE INTO [dbo].[UsrAuditOperation] AS TARGET
USING(VALUES
(1, N'Agregar'),
(2, N'Eliminar'),
(3, N'Editar - Propiedades'),
(4, N'Editar - Cuenta'),
(5, N'Editar - Propiedades Adicionales'),
(6, N'Editar - Lenguaje'),
(7, N'Editar - Login por defecto'),
(8, N'Editar - Contraseña'),
(9, N'Editar - Asignar Imagen'),
(10, N'Editar - Delegados'),
(11, N'Editar - Verticales'),
(12, N'Editar - Prop. Extendidas'),
(13, N'Editar - Idiomas'),
(14, N'Editar - Unidades Operacionales'),
(15, N'Editar - Permisos'),
(16, N'Editar - Servicios'),
(17, N'Editar - Usuarios'),
(18, N'Editar - Organizaciones'),
(19, N'Editar - Asignar propiedades'),
(20, N'Editar - Asignar propiedades Extendidas'),
(21, N'Propiedades Extendidas - Agregar Grupo'),
(22, N'Propiedades Extendidas - Importar Grupo'),
(23, N'Propiedades Extendidas - Exportar Grupo'),
(24, N'Propiedades Extendidas - Editar Grupo'),
(25, N'Propiedades Extendidas - Eliminar Grupo'),
(26, N'Propiedades Extendidas - Nuevo Item'),
(27, N'Propiedades Extendidas - Eliminar Item'),
(28, N'Propiedades Extendidas - Editar Item'),
(29, N'Integración Active Directory - Integrar Login'),
(30, N'Integración Active Directory - Importar Usuarios'),
(31, N'Lenguajes - Eliminar'),
(32, N'Lenguajes - Agregar'),
(33, N'Administrador de permisos - Importar Grupo'),
(34, N'Administrador de permisos - Exportar Grupo'),
(35, N'Administrador de permisos - Agregar Grupo'),
(36, N'Administrador de permisos - Eliminar Grupo'),
(37, N'Administrador de permisos - Editar Grupo'),
(38, N'Administrador de permisos - Nuevo Item'),
(39, N'Administrador de permisos - Eliminar Item'),
(40, N'Administrador de permisos - Editar Item'),
(41, N'Creación masiva de usuarios - Generar'),
(42, N'Adm. WebSite - Editar')
) AS SOURCE([UsrAuditOperationId], [Description])
ON TARGET.[UsrAuditOperationId] = SOURCE.[UsrAuditOperationId]
    WHEN MATCHED
    THEN UPDATE SET [Description] = SOURCE.[Description]
    WHEN NOT MATCHED BY TARGET
    THEN
      INSERT([UsrAuditOperationId], [Description])
      VALUES([UsrAuditOperationId], [Description])
    WHEN NOT MATCHED BY SOURCE
    THEN DELETE;
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_UsrAudit_UsrAuditEntity]') AND parent_object_id = OBJECT_ID(N'[dbo].[UsrAudit]'))
ALTER TABLE [dbo].[UsrAudit]  WITH CHECK ADD  CONSTRAINT [FK_UsrAudit_UsrAuditEntity] FOREIGN KEY([EntityId])
REFERENCES [dbo].[UsrAuditEntity] ([UsrAuditEntityId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_UsrAudit_UsrAuditEntity]') AND parent_object_id = OBJECT_ID(N'[dbo].[UsrAudit]'))
ALTER TABLE [dbo].[UsrAudit] CHECK CONSTRAINT [FK_UsrAudit_UsrAuditEntity]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_UsrAudit_UsrAuditOperation]') AND parent_object_id = OBJECT_ID(N'[dbo].[UsrAudit]'))
ALTER TABLE [dbo].[UsrAudit]  WITH CHECK ADD  CONSTRAINT [FK_UsrAudit_UsrAuditOperation] FOREIGN KEY([OperationId])
REFERENCES [dbo].[UsrAuditOperation] ([UsrAuditOperationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_UsrAudit_UsrAuditOperation]') AND parent_object_id = OBJECT_ID(N'[dbo].[UsrAudit]'))
ALTER TABLE [dbo].[UsrAudit] CHECK CONSTRAINT [FK_UsrAudit_UsrAuditOperation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_UsrAudit_UsrAuditService]') AND parent_object_id = OBJECT_ID(N'[dbo].[UsrAudit]'))
ALTER TABLE [dbo].[UsrAudit]  WITH CHECK ADD  CONSTRAINT [FK_UsrAudit_UsrAuditService] FOREIGN KEY([ServiceId])
REFERENCES [dbo].[UsrAuditService] ([UsrAuditServiceId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_UsrAudit_UsrAuditService]') AND parent_object_id = OBJECT_ID(N'[dbo].[UsrAudit]'))
ALTER TABLE [dbo].[UsrAudit] CHECK CONSTRAINT [FK_UsrAudit_UsrAuditService]
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[USR_PF_UserAssignedGetAllByProfByWhereByUser]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[USR_PF_UserAssignedGetAllByProfByWhereByUser] AS' 
END
GO

/*
	Design : PECTRA Technology
	Date   : 13/07/2007
	Modif  :
	Params :
		. Id de Perfil
	Desc   :	
		Retorna todos los usuarios activos no asignados
		hasta el momento(y disponibles) a un determinado Perfil Activo
		en base al filtro definido por el usuario
*/
ALTER PROCEDURE [dbo].[USR_PF_UserAssignedGetAllByProfByWhereByUser]
	(
		@pProfId	VARCHAR(250)	= '',
		@Where		VARCHAR(4000)	= '',
		@pUsrId		VARCHAR(25)		= ''
	)
AS
SET NOCOUNT ON


DECLARE @sSelect AS VARCHAR(2000)
DECLARE @sOrderBy AS VARCHAR(200)
DECLARE @sSql AS VARCHAR(4000)
SET @sSelect ='
				SELECT DISTINCT [UsrDefinition].[UsrLastName], [UsrDefinition].[UsrFirstName], [UsrDefinition].[UsrId], [UsrDefinition].[UsrGender], [UsrDefinition].[UsrEMail], [UsrDefinition].[UsrValidate],
				[UsrOrgDefinition].[OrgId], [UsrOrgDefinition].[OrgDescription],
				[UsrUoDefinition].[UoId], [UsrUoDefinition].[UoDescription]
FROM	[UsrOrgUoUsers] WITH (NOLOCK) INNER JOIN
		[UsrOrgUoProf] WITH (NOLOCK) ON [UsrOrgUoUsers].[OrgId] = [UsrOrgUoProf].[OrgId] INNER JOIN
		[UsrDefinition] WITH (NOLOCK) ON [UsrDefinition].[UsrId] = [UsrOrgUoUsers].[UsrId] INNER JOIN
		[UsrOrgDefinition] WITH (NOLOCK) ON [UsrOrgUoUsers].[OrgId] = [UsrOrgDefinition].[OrgId] INNER JOIN
		[UsrUoDefinition] WITH (NOLOCK) ON [UsrOrgUoUsers].[UoId] = [UsrUoDefinition].[UoId] '
SET @sOrderBy =' ORDER BY [UsrDefinition].[UsrLastName] ASC, [UsrDefinition].[UsrFirstName] ASC, [UsrDefinition].[UsrId] ASC, [UsrOrgDefinition].[OrgId] ASC, [UsrUoDefinition].[UoId] ASC'
SET @Where = @Where + ' AND [UsrOrgUoUsers].[Activo] = 1 AND
							[UsrOrgUoProf].[Activo]  = 1 AND
							([UsrOrgUoUsers].[UoId] IN ( 
										SELECT DISTINCT [UsrOrgUoProf].[UoId]
										FROM	[UsrOrgProfUsers] WITH (NOLOCK) INNER JOIN
												[UsrOrgUoProf] WITH (NOLOCK) ON [UsrOrgProfUsers].[OrgId] = [UsrOrgUoProf].[OrgId]
										WHERE 
												(
													[UsrOrgUoProf].[ProfId] = ''' + @pProfId + ''' AND
													[UsrOrgUoProf].[Activo] = 1
												)
										)
									) AND 
									([UsrOrgUoUsers].[OrgId] IN (
																	SELECT DISTINCT [UsrOrgUoProf].[OrgId]
																	FROM	[UsrOrgProfUsers] WITH (NOLOCK) INNER JOIN
																			[UsrOrgUoProf] WITH (NOLOCK) ON [UsrOrgProfUsers].[OrgId] = [UsrOrgUoProf].[OrgId]
																	WHERE     
																			(
																				[UsrOrgUoProf].[ProfId] = ''' + @pProfId + ''' AND
																				[UsrOrgUoProf].[Activo] = 1
																			)
																)
									) AND
									([UsrOrgUoUsers].[UsrId] IN
																(
																	SELECT DISTINCT [UsrOrgProfUsers].[UsrId]
																	FROM [UsrOrgProfUsers] WITH (NOLOCK)
																	WHERE	[UsrOrgProfUsers].[ProfId]	= ''' + @pProfId + ''' AND
																			[UsrOrgProfUsers].[Activo]	= 1 AND
																			[UsrOrgProfUsers].[OrgId] = [UsrOrgUoUsers].[OrgId] AND
																			[UsrOrgProfUsers].[UoId] = [UsrOrgUoUsers].[UoId]
															
																)
									) AND
									[UsrOrgUoUsers].[UsrId]	IN
													(
														-- retorno todos los usuarios que se encuentran en las mismas organizaciones
														-- que el usuario que viene por parametro (usuario logueado)
 														SELECT DISTINCT [UsrOrgUoUsers1].[UsrId]
														FROM	[UsrOrgUoUsers] AS [UsrOrgUoUsers1] WITH (NOLOCK) INNER JOIN
																[UsrOrgUoUsers] AS [UsrOrgUoUsers2] WITH (NOLOCK) ON
																[UsrOrgUoUsers1].[OrgId]	= [UsrOrgUoUsers2].[OrgId]
														WHERE	[UsrOrgUoUsers2].[UsrId]	= ''' + @pUsrId + ''' AND
																[UsrOrgUoUsers2].[Activo]	= 1 AND
																[UsrOrgUoUsers1].[Activo]   = 1
													)'
SET @sSql = @sSelect + 'WHERE ' + @Where + @sOrderBy
EXECUTE(@sSql)

RETURN
/****** Objeto:  StoredProcedure [dbo].[USR_PF_UserAssignedGetAllByProf]    Fecha de la secuencia de comandos: 08/24/2007 15:19:15 ******/
SET ANSI_NULLS ON

GO


PRINT N'Actualización completada.';


GO
