﻿$gacfolder = 'c:\Program Files (x86)\Pectra Technology\Pectra BPMSuite\Common\GAC\'
$srvFolder = 'c:\Program Files (x86)\Pectra Technology\Pectra BPMSuite\Server\'
$loginSite = 'IIS:\Sites\Default Web Site\PectraPortal\Login'
$usrmanagerSite = 'IIS:\Sites\Default Web Site\PectraPortal\UsrManager'
$tracerSite = 'IIS:\Sites\Default Web Site\PectraPortal\Tracer' 

$pectrav4AppPool = 'Pectra v4'

[System.Reflection.Assembly]::Load("System.EnterpriseServices, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")            
$publish = New-Object System.EnterpriseServices.Internal.Publish    

$publish.GacInstall($gacfolder + "Dapper.StrongName.dll")
$publish.GacInstall($gacfolder + "Interop.MSScriptControl.dll")
$publish.GacInstall($gacfolder + "log4net.dll")
$publish.GacInstall($gacfolder + "Microsoft.Practices.EnterpriseLibrary.Caching.Cryptography.dll")
$publish.GacInstall($gacfolder + "Microsoft.Practices.EnterpriseLibrary.Caching.dll")
$publish.GacInstall($gacfolder + "Microsoft.Practices.EnterpriseLibrary.Common.dll")
$publish.GacInstall($gacfolder + "Microsoft.Practices.EnterpriseLibrary.Data.dll")
$publish.GacInstall($gacfolder + "Microsoft.Practices.EnterpriseLibrary.Security.Cryptography.dll")
$publish.GacInstall($gacfolder + "Microsoft.Practices.ObjectBuilder.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Common.BPInterface.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Common.CnnFncInterface.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Common.Common.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Common.DAC.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Common.Entities.LogEntity.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Common.PectraPkgMng.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.BPService.Components.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.BPService.Data.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.BPService.Data.SqlClient.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.BPService.Entities.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.EvdData.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.EvdGenerator.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.EvdProcessor.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.NtfData.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.RbtBPEControlDue.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.RbtData.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.RbtGenerator.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.RbtProcessor.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.RbtScriptEngine.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.SchData.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.SchGenerator.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Services.SchProcessor.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Utils.LogManager.dll")
$publish.GacInstall($gacfolder + "PECTRA.BPMSuite.Utils.Reflection.dll")
$publish.GacInstall($gacfolder + "PectraCnnManagerNET.dll")
$publish.GacInstall($gacfolder + "PectraOBPINET.dll")
$publish.GacInstall($gacfolder + "PectraShieldDataNET.dll")
$publish.GacInstall($gacfolder + "Prominente.DvProductos.Helpers.Data.dll")
$publish.GacInstall($gacfolder + "Prominente.DvProductos.Libraries.gMSGQ.Common.dll")
$publish.GacInstall($gacfolder + "Prominente.DvProductos.Libraries.gMSGQ.Core.dll")
$publish.GacInstall($gacfolder + "PectraAudit.dll")


sc.exe delete 'PectraEvdService'
sc.exe delete 'PectraRbtService'
sc.exe delete 'PectraSchService'

New-Service -BinaryPathName $srvFolder"EventDispatcher\PECTRA.BPMSuite.Services.EvdService.exe" -Name 'PectraEvdService' -DisplayName 'PECTRA EVD Service' -Description 'Procesa los eventos generados por actividades de un proceso de negocio.'
New-Service -BinaryPathName $srvFolder"Robot\PECTRA.BPMSuite.Services.RbtService.exe" -Name 'PectraRbtService' -DisplayName 'PECTRA RBT Service' -Description 'Ejecuta las secuencias de comandos incluidas en un proceso de negocio.'
New-Service -BinaryPathName $srvFolder"Scheduler\PECTRA.BPMSuite.Services.SchService.exe" -Name 'PectraSchService' -DisplayName 'PECTRA SCH Service' -Description 'Permite la ejecución de trabajos programados en el tiempo.'

#Borrar assemblies previos
If (Test-Path $srvFolder"DigitalGate\WebSite\UsrManager\bin\PECTRA.BPMSuite.Utils.LogManager.dll" ){
	Remove-Item $srvFolder"DigitalGate\WebSite\UsrManager\bin\PECTRA.BPMSuite.Utils.LogManager.dll"
}
If (Test-Path $srvFolder"DigitalGate\WebSite\UsrManager\bin\PECTRA.BPMSuite.Common.Entities.LogEntity.dll" ){
	Remove-Item $srvFolder"DigitalGate\WebSite\UsrManager\bin\PECTRA.BPMSuite.Common.Entities.LogEntity.dll"
}
#Fin borrar assemblies previos

#Elimina PectraOBPIWrapper
$comCatalog = New-Object -ComObject COMAdmin.COMAdminCatalog
$appColl = $comCatalog.GetCollection("Applications")
$appColl.Populate()

$app = $appColl | where {$_.Name -eq "Pectra BPMSuite - OBPI"}
$compColl = $appColl.GetCollection("Components", $app.Key)
$compColl.Populate()

$index = 0
foreach($component in $compColl) {
    if ($component.Name -eq "PectraOBPIWrapper.Engine") {
        $compColl.Remove($index)
        $compColl.SaveChanges()
    }
    $index++
}

#Elimina RbtAnlEjec
$app = $appColl | where {$_.Name -eq "Pectra BPMSuite - Robot"}
$compColl = $appColl.GetCollection("Components", $app.Key)
$compColl.Populate()

$index = 0
$found = $false
foreach($component in $compColl) {
    if ($component.Name -eq "RbtAnlEjec.Engine") {
        $found = $true
        break
    }
    $index++
}
if ($true -eq $found) {
    $compColl.Remove($index)
    $compColl.SaveChanges()
}

#Elimina WFGenerator
$app = $appColl | where {$_.Name -eq "Pectra BPMSuite - WF Integration"}
$compColl = $appColl.GetCollection("Components", $app.Key)
$compColl.Populate()

$index = 0
$found = $false
foreach($component in $compColl) {
    if ($component.Name -eq "WFGenerator.Engine") {
        $found = $true
        break
    }
    $index++
}
if ($true -eq $found) {
    $compColl.Remove($index)
    $compColl.SaveChanges()
    Write-Host "WFGenerator.Engine eliminado."
}

$index = 0
$found = $false
foreach($component in $compColl) {
    if ($component.Name -eq "WFGenerator.ItemMap") {
        $found = $true
        break
    }
    $index++
}
if ($true -eq $found) {
    $compColl.Remove($index)
    $compColl.SaveChanges()
    Write-Host "WFGenerator.ItemMap eliminado."
}
#Fin WFGenerator

#Agrega PectraOBPIWrapper
$comAdmin = New-Object -comobject COMAdmin.COMAdminCatalog;
$comAdmin.InstallComponent("Pectra BPMSuite - OBPI", $srvFolder + "Obpi\ComPlus\PectraOBPIWrapper.dll", $null, $null);

#Agrega PectraAudit
$comAdminAudit = New-Object -comobject COMAdmin.COMAdminCatalog;
$comAdminAudit.InstallComponent("Pectra BPMSuite - Digital Gate", $gacFolder + "PectraAudit.dll", $null, $null);

#Agrega RbtAnlEjec
$comAdminRbt = New-Object -comobject COMAdmin.COMAdminCatalog;
$comAdminRbt.InstallComponent("Pectra BPMSuite - Robot", $srvFolder + "Robot\ComPlus\RbtAnlEjec.dll", $null, $null);

#Agrega WF
$comAdminRbt = New-Object -comobject COMAdmin.COMAdminCatalog;
$comAdminRbt.InstallComponent("Pectra BPMSuite - WF Integration", $srvFolder + "WF\WFGenerator.dll", $null, $null);

# Inicia servicios
function StartSvc($svcName)
{
    $svc = Start-Service -Name $svcName -PassThru
    Write-Host $svcName ": Iniciando."
    $svc.WaitForStatus('Running')
    Write-Host "Iniciado."
}

StartSvc('PECTRA BAM Service')
StartSvc('PECTRA Designer Service Interface')
StartSvc('PECTRA Digital Gate Service')
StartSvc('PECTRA Engine Service')
StartSvc('PECTRA Engine Service Interface')
StartSvc('PectraEvdService')
StartSvc('PECTRA LOG Manager')
StartSvc('PectraNewsRssService')
StartSvc('PectraNtfService')
StartSvc('PectraRbtService')
StartSvc('PectraSchService')
StartSvc('WFService')

import-module WebAdministration
Set-ItemProperty $loginSite applicationPool $pectrav4AppPool
Set-ItemProperty $usrmanagerSite applicationPool $pectrav4AppPool
Set-ItemProperty $tracerSite applicationPool $pectrav4AppPool

iisreset /start